/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.helper;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.nio.ByteOrder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class ColorHelper {
    private static final Int2IntFunction colorSwapper = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? color -> color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16 : color -> color;

    private ColorHelper() {
    }

    public static int swapRedBlueIfNeeded(int color) {
        return colorSwapper.applyAsInt(color);
    }

    public static int multiplyColor(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        if (color2 == -1) {
            return color1;
        }
        int alpha = (color1 >> 24 & 0xFF) * (color2 >> 24 & 0xFF) / 255;
        int red = (color1 >> 16 & 0xFF) * (color2 >> 16 & 0xFF) / 255;
        int green = (color1 >> 8 & 0xFF) * (color2 >> 8 & 0xFF) / 255;
        int blue = (color1 & 0xFF) * (color2 & 0xFF) / 255;
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int multiplyRGB(int color, float shade) {
        int alpha = color >> 24 & 0xFF;
        int red = (int)((float)(color >> 16 & 0xFF) * shade);
        int green = (int)((float)(color >> 8 & 0xFF) * shade);
        int blue = (int)((float)(color & 0xFF) * shade);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int maxBrightness(int b0, int b1) {
        if (b0 == 0) {
            return b1;
        }
        if (b1 == 0) {
            return b0;
        }
        return Math.max(b0 & 0xFFFF, b1 & 0xFFFF) | Math.max(b0 & 0xFFFF0000, b1 & 0xFFFF0000);
    }
}

