/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.api.recipe.v1.ingredient.FabricIngredient;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1856.class})
public class IngredientMixin
implements FabricIngredient {
    @Inject(at={@At(value="INVOKE", target="net/minecraft/recipe/Ingredient.entryFromJson (Lcom/google/gson/JsonObject;)Lnet/minecraft/recipe/Ingredient$Entry;", ordinal=0)}, method={"fromJson"}, cancellable=true)
    private static void injectFromJson(JsonElement json, CallbackInfoReturnable<class_1856> cir) {
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("fabric:type")) {
            class_2960 id = new class_2960(class_3518.method_15265((JsonObject)obj, (String)"fabric:type"));
            CustomIngredientSerializer<?> serializer = CustomIngredientSerializer.get(id);
            if (serializer != null) {
                cir.setReturnValue((Object)serializer.read(obj).toVanilla());
            } else {
                throw new IllegalArgumentException("Unknown custom ingredient type: " + String.valueOf(id));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"entryFromJson"})
    private static void injectEntryFromJson(JsonObject obj, CallbackInfoReturnable<?> cir) {
        if (obj.has("fabric:type")) {
            throw new IllegalArgumentException("Custom ingredient cannot be used inside an array ingredient. You can replace the array by a fabric:any ingredient.");
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"fromPacket"}, cancellable=true)
    private static void injectFromPacket(class_2540 buf, CallbackInfoReturnable<class_1856> cir) {
        int index = buf.readerIndex();
        if (buf.method_10816() == -1) {
            class_2960 type = buf.method_10810();
            CustomIngredientSerializer<?> serializer = CustomIngredientSerializer.get(type);
            if (serializer == null) {
                throw new IllegalArgumentException("Cannot deserialize custom ingredient of unknown type " + String.valueOf(type));
            }
            cir.setReturnValue((Object)serializer.read(buf).toVanilla());
        } else {
            buf.readerIndex(index);
        }
    }
}

