/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.api.external.events;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.List;

public interface AbstractEvent<Context> {
    public static final String GENERIC_LOCATION = "generic";
    public static final List<String> GENERIC_LOCATION_LIST = List.of("generic");

    default public EventArgs<Context> stableArgs(StableEventArgs<Context> eventArgs) {
        return eventArgs;
    }

    default public boolean isNotEmpty() {
        for (String location : this.getLocationList()) {
            if (!this.isNotEmpty(location)) continue;
            return true;
        }
        return false;
    }

    default public boolean isNotEmpty(String ... locations) {
        for (String location : locations) {
            EventHolder eventHolder = (EventHolder)this.getStorage().get((Object)location);
            if (eventHolder == null) continue;
            for (Long priority : eventHolder.priorityHolder()) {
                if (((List)eventHolder.argsHolder.get(priority.longValue())).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void clean();

    default public EventHolder<Context> getNewHolder() {
        return new EventHolder(new Long2ObjectLinkedOpenHashMap(), new ArrayList<Long>());
    }

    public Object2ObjectMap<String, EventHolder<Context>> getStorage();

    public List<String> getLocationList();

    public void removeThreadSafe(long var1, List<String> var3, EventArgs<Context> var4);

    default public void removeThreadSafe(long priority, EventArgs<Context> eventArgs) {
        this.removeThreadSafe(priority, GENERIC_LOCATION_LIST, eventArgs);
    }

    public void removeThreadUnsafe(long var1, List<String> var3, EventArgs<Context> var4);

    default public void removeThreadUnsafe(long priority, EventArgs<Context> eventArgs) {
        this.removeThreadUnsafe(priority, GENERIC_LOCATION_LIST, eventArgs);
    }

    public void registerThreadsafe(long var1, List<String> var3, ArgsProvider<Context> var4);

    default public void registerThreadsafe(long priority, ArgsProvider<Context> argsProvider) {
        this.registerThreadsafe(priority, GENERIC_LOCATION_LIST, argsProvider);
    }

    public void registerThreadUnsafe(long var1, List<String> var3, ArgsProvider<Context> var4);

    default public void registerThreadUnsafe(long priority, ArgsProvider<Context> argsProvider) {
        this.registerThreadUnsafe(priority, GENERIC_LOCATION_LIST, argsProvider);
    }

    public void fire(List<String> var1, boolean var2, Context var3);

    default public void fire(List<String> locations, Context eventContext) {
        this.fire(locations, false, eventContext);
    }

    default public void fire(boolean orderFlipped, Context eventContext) {
        this.fire(GENERIC_LOCATION_LIST, orderFlipped, eventContext);
    }

    default public void fire(Context eventContext) {
        this.fire(GENERIC_LOCATION_LIST, false, eventContext);
    }

    public record EventHolder<Ctx>(Long2ObjectMap<List<EventArgs<Ctx>>> argsHolder, ArrayList<Long> priorityHolder) {
    }

    @FunctionalInterface
    public static interface EventArgs<Ctx> {
        public EventArgs<Ctx> recursive(Ctx var1, AbstractEvent<Ctx> var2, Object var3, EventArgs<Ctx> var4);
    }

    @FunctionalInterface
    public static interface ArgsProvider<Ctx> {
        public EventArgs<Ctx> getEvent(AbstractEvent<Ctx> var1);
    }

    @FunctionalInterface
    public static interface StableEventArgs<Ctx>
    extends EventArgs<Ctx> {
        @Override
        default public EventArgs<Ctx> recursive(Ctx eventContext, AbstractEvent<Ctx> event, Object closer, EventArgs<Ctx> eventArgs) {
            this.stable(eventContext, eventArgs);
            return null;
        }

        public void stable(Ctx var1, EventArgs<Ctx> var2);
    }
}

