/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.api.external.abstraction.core.versioning;

import io.github.bumblesoftware.fastload.config.FLMath;
import io.github.bumblesoftware.fastload.init.Fastload;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.jetbrains.annotations.Nullable;

public class VersionUtil {

    public static enum MatchingStrategy {
        EQUALS(String::equals),
        REGEX(MatchingStrategy::regexMatch);

        public final BiFunction<String, String, Boolean> function;

        private MatchingStrategy(BiFunction<String, String, Boolean> function) {
            this.function = function;
        }

        public static boolean regexMatch(String main, String regex) {
            char[] mainChars;
            int matchesInARow = 0;
            char[] regexChars = regex.toCharArray();
            for (char mainChar : mainChars = main.toCharArray()) {
                matchesInARow = regexChars[matchesInARow] == mainChar ? ++matchesInARow : 0;
                if (matchesInARow != regexChars.length) continue;
                return true;
            }
            return false;
        }
    }

    public static enum ExceptionStrategy {
        NO_EXCEPTION(version -> true),
        ONLY_FIRST_MAJOR(version -> {
            char[] array = version.toCharArray();
            return array.length < 6 || array[4] != '.' || !Character.isDigit(array[5]);
        });

        public final Function<String, Boolean> function;

        private ExceptionStrategy(Function<String, Boolean> function) {
            this.function = function;
        }
    }

    public static class VersionPackage {
        private final String info;
        private final Function<String, String> versionGetter;

        private VersionPackage(String name, @Nullable Function<String, String> versionGetter) {
            this.info = name;
            this.versionGetter = Objects.requireNonNullElseGet(versionGetter, () -> string -> string);
        }

        public String getVersion() {
            return this.versionGetter.apply(this.info);
        }

        public static VersionPackage of(String info, @Nullable Function<String, String> versionGetter) {
            return new VersionPackage(info, versionGetter);
        }

        public static VersionPackage ofVersion(String version) {
            return VersionPackage.of(version, null);
        }

        public static VersionPackage ofFmjVersion(String name) {
            return VersionPackage.of(name, VersionPackage::getFmjVersion);
        }

        public static String getFmjVersion(String name) {
            return ((ModContainer)FabricLoader.getInstance().getModContainer(name).orElseThrow()).getMetadata().getVersion().getFriendlyString();
        }
    }

    public static class GameSpecific {
        public final String gameId;
        public final String providedVersion;
        public final MatchingStrategy defaultMatchingStrategy;
        public final ExceptionStrategy defaultException;

        public GameSpecific(String gameId, Function<String, VersionPackage> providedVersion, MatchingStrategy defaultMatchingStrategy, ExceptionStrategy defaultException) {
            this.gameId = gameId;
            this.providedVersion = providedVersion.apply(gameId).getVersion();
            this.defaultMatchingStrategy = defaultMatchingStrategy;
            this.defaultException = defaultException;
        }

        public String toString() {
            return "VersionHelper.GameSpecific[id=" + this.gameId + ",version= " + this.providedVersion + "]" + this.hashCode();
        }

        public boolean matchesAny(String comparedVersion, MatchingStrategy strategy, ExceptionStrategy checkForExceptions) {
            boolean matches;
            boolean bl = matches = strategy.function.apply(this.providedVersion, comparedVersion) != false && checkForExceptions.function.apply(this.providedVersion) != false;
            if (FLMath.isDebugEnabled().booleanValue()) {
                Fastload.LOGGER.info("VERSIONS:[" + this.providedVersion + ", " + comparedVersion + "], MATCHES: " + matches + ", STRATEGY: " + strategy.name());
            }
            return matches;
        }

        public boolean matchesAny(String comparedVersion, MatchingStrategy strategy) {
            return this.matchesAny(comparedVersion, strategy, this.defaultException);
        }

        public boolean matchesAny(String comparedVersion, ExceptionStrategy checkForExceptions) {
            return this.matchesAny(comparedVersion, this.defaultMatchingStrategy, checkForExceptions);
        }

        public boolean matchesAny(String comparedVersion) {
            return this.matchesAny(comparedVersion, this.defaultMatchingStrategy, this.defaultException);
        }
    }
}

