/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.api.external.abstraction.core.handler;

import io.github.bumblesoftware.fastload.api.external.abstraction.core.handler.AbstractionDirectory;
import io.github.bumblesoftware.fastload.api.external.abstraction.core.handler.AbstractionEntrypoint;
import io.github.bumblesoftware.fastload.api.external.abstraction.core.handler.MethodAbstractionApi;
import io.github.bumblesoftware.fastload.api.external.events.AbstractEvent;
import io.github.bumblesoftware.fastload.api.external.events.CapableEvent;
import io.github.bumblesoftware.fastload.util.MutableObjectHolder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;

public class AbstractionHandler<A extends MethodAbstractionApi> {
    public final AbstractionDirectory<A> directory;
    public final List<String> abstractionModIds;
    public final Environment environment;
    public final String entrypointName;

    AbstractionHandler(String namespace, List<String> abstractionModIds, Environment environment, Consumer<AbstractEvent<MutableObjectHolder<A>>> base, Function<A, AbstractionDirectory<A>> abstractionInstanceGetter) {
        CapableEvent event = new CapableEvent();
        MutableObjectHolder abstractionApiHolder = new MutableObjectHolder();
        String entrypointName = namespace.toLowerCase() + "_" + environment.name().toLowerCase();
        base.accept(event);
        FabricLoader.getInstance().getEntrypointContainers(entrypointName, AbstractionEntrypoint.class).forEach(container -> abstractionModIds.forEach(abstractionModId -> {
            if (container.getProvider().getMetadata().getId().equals(abstractionModId)) {
                ((AbstractionEntrypoint)container.getEntrypoint()).register(event);
            }
        }));
        event.fire(abstractionApiHolder);
        this.directory = abstractionInstanceGetter.apply((MethodAbstractionApi)abstractionApiHolder.heldObj);
        this.abstractionModIds = abstractionModIds;
        this.environment = environment;
        this.entrypointName = entrypointName;
        if (abstractionApiHolder.heldObj == null) {
            throw new NullPointerException("Abstraction failed for " + this);
        }
    }

    public String toString() {
        return "AbstractionHandler[Env={" + this.environment + "}, ENTRYPOINT_NAME={" + this.entrypointName + "}, ENTRYPOINT_MODIDS={" + Arrays.toString(this.abstractionModIds.toArray()) + "}]@" + this.hashCode();
    }

    public static enum Environment {
        CLIENT,
        COMMON;

    }
}

