/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.resource.conditions.v1;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7696;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class DefaultResourceConditions {
    private static final class_2960 NOT = new class_2960("fabric:not");
    private static final class_2960 AND = new class_2960("fabric:and");
    private static final class_2960 OR = new class_2960("fabric:or");
    private static final class_2960 ALL_MODS_LOADED = new class_2960("fabric:all_mods_loaded");
    private static final class_2960 ANY_MOD_LOADED = new class_2960("fabric:any_mod_loaded");
    private static final class_2960 BLOCK_TAGS_POPULATED = new class_2960("fabric:block_tags_populated");
    private static final class_2960 FLUID_TAGS_POPULATED = new class_2960("fabric:fluid_tags_populated");
    private static final class_2960 ITEM_TAGS_POPULATED = new class_2960("fabric:item_tags_populated");
    private static final class_2960 TAGS_POPULATED = new class_2960("fabric:tags_populated");
    private static final class_2960 FEATURES_ENABLED = new class_2960("fabric:features_enabled");
    private static final class_2960 REGISTRY_CONTAINS = new class_2960("fabric:registry_contains");

    public static ConditionJsonProvider not(final ConditionJsonProvider value) {
        return new ConditionJsonProvider(){

            @Override
            public void writeParameters(JsonObject object) {
                object.add("value", (JsonElement)value.toJson());
            }

            @Override
            public class_2960 getConditionId() {
                return NOT;
            }
        };
    }

    public static ConditionJsonProvider and(ConditionJsonProvider ... values) {
        return ResourceConditionsImpl.array(AND, values);
    }

    public static ConditionJsonProvider or(ConditionJsonProvider ... values) {
        return ResourceConditionsImpl.array(OR, values);
    }

    public static ConditionJsonProvider allModsLoaded(String ... modIds) {
        return ResourceConditionsImpl.mods(ALL_MODS_LOADED, modIds);
    }

    public static ConditionJsonProvider anyModLoaded(String ... modIds) {
        return ResourceConditionsImpl.mods(ANY_MOD_LOADED, modIds);
    }

    @SafeVarargs
    @Deprecated
    public static ConditionJsonProvider blockTagsPopulated(class_6862<class_2248> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(BLOCK_TAGS_POPULATED, false, tags);
    }

    @SafeVarargs
    @Deprecated
    public static ConditionJsonProvider fluidTagsPopulated(class_6862<class_3611> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(FLUID_TAGS_POPULATED, false, tags);
    }

    @SafeVarargs
    @Deprecated
    public static ConditionJsonProvider itemTagsPopulated(class_6862<class_1792> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(ITEM_TAGS_POPULATED, false, tags);
    }

    @SafeVarargs
    public static <T> ConditionJsonProvider tagsPopulated(class_6862<T> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(TAGS_POPULATED, true, tags);
    }

    public static ConditionJsonProvider featuresEnabled(class_7696 ... features) {
        return ResourceConditionsImpl.featuresEnabled(FEATURES_ENABLED, features);
    }

    public static ConditionJsonProvider itemsRegistered(class_1935 ... items) {
        return DefaultResourceConditions.registryContains(class_7923.field_41178, DefaultResourceConditions.transform(items, class_1935::method_8389, new class_1792[0]));
    }

    @SafeVarargs
    public static <T> ConditionJsonProvider registryContains(class_2378<T> registry, T ... entries) {
        return DefaultResourceConditions.registryContains(DefaultResourceConditions.transform(entries, e -> (class_5321)registry.method_29113(e).orElseThrow(() -> new IllegalArgumentException("Entry is not registered")), new class_5321[0]));
    }

    @SafeVarargs
    public static <T> ConditionJsonProvider registryContains(class_5321<T> ... entries) {
        Preconditions.checkArgument((entries.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one entry.");
        return DefaultResourceConditions.registryContains(class_5321.method_29180((class_2960)entries[0].method_41185()), DefaultResourceConditions.transform(entries, class_5321::method_29177, new class_2960[0]));
    }

    public static <T> ConditionJsonProvider registryContains(class_5321<class_2378<T>> registry, class_2960 ... entries) {
        return ResourceConditionsImpl.registryContains(REGISTRY_CONTAINS, registry.method_29177(), entries);
    }

    static void init() {
    }

    @SafeVarargs
    private static <A, B> B[] transform(A[] input, Function<A, B> mapper, B ... outputType) {
        B[] output = Arrays.copyOf(outputType, input.length);
        for (int i = 0; i < input.length; ++i) {
            output[i] = mapper.apply(input[i]);
        }
        return output;
    }

    private DefaultResourceConditions() {
    }

    static {
        ResourceConditions.register(NOT, object -> {
            JsonObject condition = class_3518.method_15296((JsonObject)object, (String)"value");
            return !ResourceConditions.conditionMatches(condition);
        });
        ResourceConditions.register(AND, object -> {
            JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
            return ResourceConditions.conditionsMatch(array, true);
        });
        ResourceConditions.register(OR, object -> {
            JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
            return ResourceConditions.conditionsMatch(array, false);
        });
        ResourceConditions.register(ALL_MODS_LOADED, object -> ResourceConditionsImpl.modsLoadedMatch(object, true));
        ResourceConditions.register(ANY_MOD_LOADED, object -> ResourceConditionsImpl.modsLoadedMatch(object, false));
        ResourceConditions.register(BLOCK_TAGS_POPULATED, object -> ResourceConditionsImpl.tagsPopulatedMatch(object, class_7924.field_41254));
        ResourceConditions.register(FLUID_TAGS_POPULATED, object -> ResourceConditionsImpl.tagsPopulatedMatch(object, class_7924.field_41270));
        ResourceConditions.register(ITEM_TAGS_POPULATED, object -> ResourceConditionsImpl.tagsPopulatedMatch(object, class_7924.field_41197));
        ResourceConditions.register(TAGS_POPULATED, ResourceConditionsImpl::tagsPopulatedMatch);
        ResourceConditions.register(FEATURES_ENABLED, ResourceConditionsImpl::featuresEnabledMatch);
        ResourceConditions.register(REGISTRY_CONTAINS, ResourceConditionsImpl::registryContainsMatch);
    }
}

