/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_2405;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class FabricRecipeProvider
extends class_2446 {
    protected final FabricDataOutput output;

    public FabricRecipeProvider(FabricDataOutput output) {
        super((class_7784)output);
        this.output = output;
    }

    public abstract void method_10419(Consumer<class_2444> var1);

    protected Consumer<class_2444> withConditions(Consumer<class_2444> exporter, ConditionJsonProvider ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return json -> {
            FabricDataGenHelper.addConditions(json, conditions);
            exporter.accept((class_2444)json);
        };
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        HashSet generatedRecipes = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.method_10419(provider -> {
            class_2960 identifier = this.getRecipeIdentifier(provider.method_10417());
            if (!generatedRecipes.add(identifier)) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(identifier));
            }
            JsonObject recipeJson = provider.method_17799();
            ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions(provider);
            ConditionJsonProvider.write((JsonObject)recipeJson, (ConditionJsonProvider[])conditions);
            list.add(class_2405.method_10320((class_7403)writer, (JsonElement)recipeJson, (Path)this.field_39378.method_44107(identifier)));
            JsonObject advancementJson = provider.method_10415();
            if (advancementJson != null) {
                ConditionJsonProvider.write((JsonObject)advancementJson, (ConditionJsonProvider[])conditions);
                list.add(class_2405.method_10320((class_7403)writer, (JsonElement)advancementJson, (Path)this.field_39379.method_44107(this.getRecipeIdentifier(provider.method_10418()))));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected class_2960 getRecipeIdentifier(class_2960 identifier) {
        return new class_2960(this.output.getModId(), identifier.method_12832());
    }
}

