/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class FabricCodecDataProvider<T>
implements class_2405 {
    private final class_7784.class_7489 pathResolver;
    private final Codec<T> codec;

    protected FabricCodecDataProvider(FabricDataOutput dataOutput, class_7784.class_7490 outputType, String directoryName, Codec<T> codec) {
        this.pathResolver = dataOutput.method_45973(outputType, directoryName);
        this.codec = codec;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        HashMap<class_2960, JsonElement> entries = new HashMap<class_2960, JsonElement>();
        BiConsumer<class_2960, Object> provider = (id, value) -> {
            JsonElement json = this.convert((class_2960)id, (T)value);
            JsonElement existingJson = entries.put((class_2960)id, json);
            if (existingJson != null) {
                throw new IllegalArgumentException("Duplicate entry " + String.valueOf(id));
            }
        };
        this.configure(provider);
        return this.write(writer, entries);
    }

    protected abstract void configure(BiConsumer<class_2960, T> var1);

    private JsonElement convert(class_2960 id, T value) {
        DataResult dataResult = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value);
        return (JsonElement)dataResult.get().mapRight(partial -> "Invalid entry %s: %s".formatted(id, partial.message())).orThrow();
    }

    private CompletableFuture<?> write(class_7403 writer, Map<class_2960, JsonElement> entries) {
        return CompletableFuture.allOf((CompletableFuture[])entries.entrySet().stream().map(entry -> {
            Path path = this.pathResolver.method_44107((class_2960)entry.getKey());
            return class_2405.method_10320((class_7403)writer, (JsonElement)((JsonElement)entry.getValue()), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }
}

