/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_7701;
import net.minecraft.class_7788;
import net.minecraft.class_7923;

public abstract class FabricBlockLootTableProvider
extends class_7788
implements FabricLootTableProvider {
    private final FabricDataOutput output;
    private final Set<class_2960> excludedFromStrictValidation = new HashSet<class_2960>();

    protected FabricBlockLootTableProvider(FabricDataOutput dataOutput) {
        super(Collections.emptySet(), class_7701.field_40180.method_45383());
        this.output = dataOutput;
    }

    public abstract void method_10379();

    public void excludeFromStrictValidation(class_2248 block) {
        this.excludedFromStrictValidation.add(class_7923.field_41175.method_10221((Object)block));
    }

    @Override
    public class_176 getLootContextType() {
        return class_173.field_1172;
    }

    @Override
    public FabricDataOutput getFabricDataOutput() {
        return this.output;
    }

    public void method_10399(BiConsumer<class_2960, class_52.class_53> biConsumer) {
        this.method_10379();
        for (Map.Entry entry : this.field_40610.entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            if (identifier.equals((Object)class_39.field_844)) continue;
            biConsumer.accept(identifier, (class_52.class_53)entry.getValue());
        }
        if (this.output.isStrictValidationEnabled()) {
            HashSet missing = Sets.newHashSet();
            for (class_2960 blockId : class_7923.field_41175.method_10235()) {
                class_2960 blockLootTableId;
                if (!blockId.method_12836().equals(this.output.getModId()) || !(blockLootTableId = ((class_2248)class_7923.field_41175.method_10223(blockId)).method_26162()).method_12836().equals(this.output.getModId()) || this.field_40610.containsKey(blockLootTableId)) continue;
                missing.add(blockId);
            }
            missing.removeAll(this.excludedFromStrictValidation);
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing loot table(s) for %s".formatted(missing));
            }
        }
    }

    public String method_10321() {
        return "Block Loot Tables";
    }
}

