/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.player;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public final class PlayerBlockBreakEvents {
    public static final Event<Before> BEFORE = EventFactory.createArrayBacked(Before.class, listeners -> (world, player, pos, state, entity) -> {
        for (Before event : listeners) {
            boolean result = event.beforeBlockBreak(world, player, pos, state, entity);
            if (result) continue;
            return false;
        }
        return true;
    });
    public static final Event<After> AFTER = EventFactory.createArrayBacked(After.class, listeners -> (world, player, pos, state, entity) -> {
        for (After event : listeners) {
            event.afterBlockBreak(world, player, pos, state, entity);
        }
    });
    public static final Event<Canceled> CANCELED = EventFactory.createArrayBacked(Canceled.class, listeners -> (world, player, pos, state, entity) -> {
        for (Canceled event : listeners) {
            event.onBlockBreakCanceled(world, player, pos, state, entity);
        }
    });

    private PlayerBlockBreakEvents() {
    }

    @FunctionalInterface
    public static interface Canceled {
        public void onBlockBreakCanceled(class_1937 var1, class_1657 var2, class_2338 var3, class_2680 var4, @Nullable class_2586 var5);
    }

    @FunctionalInterface
    public static interface After {
        public void afterBlockBreak(class_1937 var1, class_1657 var2, class_2338 var3, class_2680 var4, @Nullable class_2586 var5);
    }

    @FunctionalInterface
    public static interface Before {
        public boolean beforeBlockBreak(class_1937 var1, class_1657 var2, class_2338 var3, class_2680 var4, @Nullable class_2586 var5);
    }
}

