/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CompatUtil {
    public static String repeat(String str, int n) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0 || n <= 0) {
            return "";
        }
        if (n == 1) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.length() * n);
        for (int i = 0; i < n; ++i) {
            builder.append(str);
        }
        return builder.toString();
    }

    @SafeVarargs
    public static <V> Set<V> setOf(V ... items) {
        return new HashSet<V>(Arrays.asList(items));
    }

    public static <V> Set<V> setOf(V item) {
        HashSet<V> set = new HashSet<V>();
        set.add(item);
        return set;
    }

    public static <V> Set<V> setOf(V itemA, V itemB) {
        HashSet<V> set = new HashSet<V>();
        set.add(itemA);
        set.add(itemB);
        return set;
    }

    @SafeVarargs
    public static <V> List<V> listOf(V ... items) {
        return Arrays.asList(items);
    }

    public static <V> Stream<V> iterateStream(final V seed, final Predicate<? super V> hasNext, final UnaryOperator<V> next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<V>(Long.MAX_VALUE, 1040){
            V prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(Consumer<? super V> action) {
                Object t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = next.apply(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!hasNext.test(t)) {
                    this.prev = null;
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super V> action) {
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                Object t = this.started ? next.apply(this.prev) : seed;
                this.prev = null;
                while (hasNext.test(t)) {
                    action.accept(t);
                    t = next.apply(t);
                }
            }
        };
        return StreamSupport.stream(spliterator, false);
    }
}

