/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.jellysquid.mods.sodium.client.util.workarounds.DriverProbe;
import me.jellysquid.mods.sodium.client.util.workarounds.DriverProbeEntrypoint;
import me.jellysquid.mods.sodium.client.util.workarounds.DriverProbeResult;
import me.jellysquid.mods.sodium.client.util.workarounds.classpath.LibraryClasspaths;
import me.jellysquid.mods.sodium.client.util.workarounds.classpath.LwjglNatives;
import me.jellysquid.mods.sodium.client.util.workarounds.classpath.ModClasspaths;
import net.minecraft.class_156;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Library;
import org.lwjgl.system.Platform;

public class DriverProbeLauncher {
    public static DriverProbeResult launchProbe() {
        Path lwjglCoreJar = (Path)Validate.notNull((Object)LibraryClasspaths.getClasspathEntry(Library.class), (String)"Could not find LWJGL Core library path", (Object[])new Object[0]);
        Path lwjglOpenGlJar = (Path)Validate.notNull((Object)LibraryClasspaths.getClasspathEntry(GL30C.class), (String)"Could not find LWJGL OpenGL library path", (Object[])new Object[0]);
        Path lwjglGlfwJar = (Path)Validate.notNull((Object)LibraryClasspaths.getClasspathEntry(GLFW.class), (String)"Could not find LWJGL GLFW library path", (Object[])new Object[0]);
        List modJarPaths = (List)Validate.notNull(ModClasspaths.getClasspathEntriesForMod(DriverProbeEntrypoint.class, "sodium"), (String)"Could not find driver prober library path", (Object[])new Object[0]);
        String lwjglCoreNativeName = (String)Validate.notNull((Object)((String)Configuration.LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)"lwjgl"))), (String)"Couldn't determine LWJGL Core native name", (Object[])new Object[0]);
        String lwjglCoreNative = (String)Validate.notNull((Object)LwjglNatives.findSystemNative("org.lwjgl", lwjglCoreNativeName), (String)"Couldn't find LWJGL Core native path", (Object[])new Object[0]);
        String lwjglOpenGlNativeName = (String)Validate.notNull((Object)Platform.mapLibraryNameBundled((String)"lwjgl_opengl"), (String)"Couldn't determine LWJGL OpenGL native name", (Object[])new Object[0]);
        String lwjglOpenGlNative = (String)Validate.notNull((Object)LwjglNatives.findSystemNative("org.lwjgl.opengl", lwjglOpenGlNativeName), (String)"Couldn't find LWJGL OpenGL native path", (Object[])new Object[0]);
        String lwjglGlfwNativeName = (String)Validate.notNull((Object)((String)Configuration.GLFW_LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)"glfw"))), (String)"Couldn't determine LWJGL GLFW native name", (Object[])new Object[0]);
        String lwjglGlfwNative = (String)Validate.notNull((Object)LwjglNatives.findBundledNative("org.lwjgl.glfw", lwjglGlfwNativeName), (String)"Couldn't find LWJGL GLFW native path", (Object[])new Object[0]);
        String jvmExecutable = (String)Validate.notNull((Object)DriverProbeLauncher.findJvmExecutable(), (String)"Couldn't find currently running JVM executable", (Object[])new Object[0]);
        HashSet<Path> classpath = new HashSet<Path>();
        classpath.add(lwjglCoreJar);
        classpath.add(lwjglOpenGlJar);
        classpath.add(lwjglGlfwJar);
        classpath.addAll(modJarPaths);
        HashSet<String> natives = new HashSet<String>();
        natives.add(DriverProbeLauncher.getDirectory(lwjglCoreNative));
        natives.add(DriverProbeLauncher.getDirectory(lwjglOpenGlNative));
        natives.add(DriverProbeLauncher.getDirectory(lwjglGlfwNative));
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(jvmExecutable);
        commands.add("-classpath");
        commands.add(classpath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
        if (class_156.method_668() == class_156.class_158.field_1137) {
            commands.add("-XstartOnFirstThread");
        }
        commands.add("-Djava.library.path=" + String.join((CharSequence)File.pathSeparator, natives));
        commands.add(DriverProbeEntrypoint.class.getName());
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(commands);
        try {
            Process process = pb.start();
            process.waitFor(5000L, TimeUnit.MILLISECONDS);
            if (process.exitValue() == 0) {
                String response = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8);
                Map<String, String> fields = DriverProbe.decodeResponse(response);
                return new DriverProbeResult(fields);
            }
            String error = IOUtils.toString((InputStream)process.getErrorStream(), (Charset)StandardCharsets.UTF_8);
            System.out.println("COMMAND LINE: " + String.join((CharSequence)",", commands));
            for (String line : error.split("\n")) {
                System.out.println("SUBPROCESS ERROR: " + line);
            }
            throw new RuntimeException("Driver probe returned exit code " + process.exitValue());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static String findJvmExecutable() {
        Optional<String> command = ProcessHandle.current().info().command();
        if (command.isEmpty()) {
            throw new RuntimeException("Currently running process does not have an accessible command structure");
        }
        return command.get();
    }

    private static String getDirectory(String file) {
        return FilenameUtils.getFullPath((String)file);
    }
}

