/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.loading;

import java.util.Objects;
import java.util.Optional;
import net.coderbot.iris.gl.blending.BlendMode;
import net.coderbot.iris.gl.blending.BlendModeFunction;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.shaderpack.loading.ProgramGroup;

public enum ProgramId {
    Shadow(ProgramGroup.Shadow, ""),
    ShadowSolid(ProgramGroup.Shadow, "solid", Shadow),
    ShadowCutout(ProgramGroup.Shadow, "cutout", Shadow),
    Basic(ProgramGroup.Gbuffers, "basic"),
    Line(ProgramGroup.Gbuffers, "line", Basic),
    Textured(ProgramGroup.Gbuffers, "textured", Basic),
    TexturedLit(ProgramGroup.Gbuffers, "textured_lit", Textured),
    SkyBasic(ProgramGroup.Gbuffers, "skybasic", Basic),
    SkyTextured(ProgramGroup.Gbuffers, "skytextured", Textured),
    Clouds(ProgramGroup.Gbuffers, "clouds", Textured),
    Terrain(ProgramGroup.Gbuffers, "terrain", TexturedLit),
    TerrainSolid(ProgramGroup.Gbuffers, "terrain_solid", Terrain),
    TerrainCutout(ProgramGroup.Gbuffers, "terrain_cutout", Terrain),
    DamagedBlock(ProgramGroup.Gbuffers, "damagedblock", Terrain),
    Block(ProgramGroup.Gbuffers, "block", Terrain),
    BlockTrans(ProgramGroup.Gbuffers, "block_translucent", Block),
    BeaconBeam(ProgramGroup.Gbuffers, "beaconbeam", Textured),
    Item(ProgramGroup.Gbuffers, "item", TexturedLit),
    Entities(ProgramGroup.Gbuffers, "entities", TexturedLit),
    EntitiesTrans(ProgramGroup.Gbuffers, "entities_translucent", Entities),
    Particles(ProgramGroup.Gbuffers, "particles", TexturedLit),
    ParticlesTrans(ProgramGroup.Gbuffers, "particles_translucent", Particles),
    EntitiesGlowing(ProgramGroup.Gbuffers, "entities_glowing", Entities),
    ArmorGlint(ProgramGroup.Gbuffers, "armor_glint", Textured),
    SpiderEyes(ProgramGroup.Gbuffers, "spidereyes", Textured, new BlendModeOverride(new BlendMode(BlendModeFunction.SRC_ALPHA.getGlId(), BlendModeFunction.ONE.getGlId(), BlendModeFunction.ZERO.getGlId(), BlendModeFunction.ONE.getGlId()))),
    Hand(ProgramGroup.Gbuffers, "hand", TexturedLit),
    Weather(ProgramGroup.Gbuffers, "weather", TexturedLit),
    Water(ProgramGroup.Gbuffers, "water", Terrain),
    HandWater(ProgramGroup.Gbuffers, "hand_water", Hand),
    Final(ProgramGroup.Final, "");

    private final ProgramGroup group;
    private final String sourceName;
    private final ProgramId fallback;
    private final BlendModeOverride defaultBlendOverride;

    private ProgramId(ProgramGroup programGroup, String string2) {
        this.group = programGroup;
        this.sourceName = string2.isEmpty() ? programGroup.getBaseName() : programGroup.getBaseName() + "_" + string2;
        this.fallback = null;
        this.defaultBlendOverride = null;
    }

    private ProgramId(ProgramGroup programGroup, String string2, ProgramId programId) {
        this.group = programGroup;
        this.sourceName = string2.isEmpty() ? programGroup.getBaseName() : programGroup.getBaseName() + "_" + string2;
        this.fallback = Objects.requireNonNull(programId);
        this.defaultBlendOverride = null;
    }

    private ProgramId(ProgramGroup programGroup, String string2, ProgramId programId, BlendModeOverride blendModeOverride) {
        this.group = programGroup;
        this.sourceName = string2.isEmpty() ? programGroup.getBaseName() : programGroup.getBaseName() + "_" + string2;
        this.fallback = Objects.requireNonNull(programId);
        this.defaultBlendOverride = blendModeOverride;
    }

    public ProgramGroup getGroup() {
        return this.group;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public Optional<ProgramId> getFallback() {
        return Optional.ofNullable(this.fallback);
    }

    public BlendModeOverride getBlendModeOverride() {
        return this.defaultBlendOverride;
    }
}

