/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.sampler;

import java.util.function.IntSupplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.sampler.GlSampler;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.texture.TextureType;

public class SamplerBinding {
    private final int textureUnit;
    private final IntSupplier texture;
    private final ValueUpdateNotifier notifier;
    private final TextureType textureType;
    private final int sampler;

    public SamplerBinding(TextureType textureType, int n, IntSupplier intSupplier, GlSampler glSampler, ValueUpdateNotifier valueUpdateNotifier) {
        this.textureType = textureType;
        this.textureUnit = n;
        this.texture = intSupplier;
        this.sampler = glSampler == null ? 0 : glSampler.getId();
        this.notifier = valueUpdateNotifier;
    }

    public void update() {
        this.updateSampler();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateSampler);
        }
    }

    private void updateSampler() {
        IrisRenderSystem.bindSamplerToUnit(this.textureUnit, this.sampler);
        IrisRenderSystem.bindTextureToUnit(this.textureType.getGlType(), this.textureUnit, this.texture.getAsInt());
    }
}

