/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.block_rendering;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class BlockRenderingSettings {
    public static final BlockRenderingSettings INSTANCE = new BlockRenderingSettings();
    private boolean reloadRequired = false;
    private Object2IntMap<class_2680> blockStateIds = null;
    private Map<class_2248, class_1921> blockTypeIds = null;
    private Object2IntFunction<NamespacedId> entityIds;
    private Object2IntFunction<NamespacedId> itemIds;
    private float ambientOcclusionLevel = 1.0f;
    private boolean disableDirectionalShading = false;
    private boolean hasVillagerConversionId = false;
    private boolean useSeparateAo = false;
    private boolean useExtendedVertexFormat = false;
    private boolean separateEntityDraws = false;
    private boolean voxelizeLightBlocks = false;

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public void clearReloadRequired() {
        this.reloadRequired = false;
    }

    @Nullable
    public Object2IntMap<class_2680> getBlockStateIds() {
        return this.blockStateIds;
    }

    @Nullable
    public Map<class_2248, class_1921> getBlockTypeIds() {
        return this.blockTypeIds;
    }

    @Nullable
    public Object2IntFunction<NamespacedId> getEntityIds() {
        return this.entityIds;
    }

    @Nullable
    public Object2IntFunction<NamespacedId> getItemIds() {
        return this.itemIds;
    }

    public void setBlockStateIds(Object2IntMap<class_2680> object2IntMap) {
        if (this.blockStateIds != null && this.blockStateIds.equals(object2IntMap)) {
            return;
        }
        this.reloadRequired = true;
        this.blockStateIds = object2IntMap;
    }

    public void setBlockTypeIds(Map<class_2248, class_1921> map) {
        if (this.blockTypeIds != null && this.blockTypeIds.equals(map)) {
            return;
        }
        this.reloadRequired = true;
        this.blockTypeIds = map;
    }

    public void setEntityIds(Object2IntFunction<NamespacedId> object2IntFunction) {
        this.entityIds = object2IntFunction;
        this.hasVillagerConversionId = object2IntFunction.containsKey((Object)new NamespacedId("minecraft", "zombie_villager_converting"));
    }

    public void setItemIds(Object2IntFunction<NamespacedId> object2IntFunction) {
        this.itemIds = object2IntFunction;
    }

    public float getAmbientOcclusionLevel() {
        return this.ambientOcclusionLevel;
    }

    public void setAmbientOcclusionLevel(float f) {
        if (f == this.ambientOcclusionLevel) {
            return;
        }
        this.reloadRequired = true;
        this.ambientOcclusionLevel = f;
    }

    public boolean shouldDisableDirectionalShading() {
        return this.disableDirectionalShading;
    }

    public void setDisableDirectionalShading(boolean bl) {
        if (bl == this.disableDirectionalShading) {
            return;
        }
        this.reloadRequired = true;
        this.disableDirectionalShading = bl;
    }

    public boolean shouldUseSeparateAo() {
        return this.useSeparateAo;
    }

    public void setUseSeparateAo(boolean bl) {
        if (bl == this.useSeparateAo) {
            return;
        }
        this.reloadRequired = true;
        this.useSeparateAo = bl;
    }

    public boolean shouldUseExtendedVertexFormat() {
        return this.useExtendedVertexFormat;
    }

    public void setUseExtendedVertexFormat(boolean bl) {
        if (bl == this.useExtendedVertexFormat) {
            return;
        }
        this.reloadRequired = true;
        this.useExtendedVertexFormat = bl;
    }

    public boolean shouldVoxelizeLightBlocks() {
        return this.voxelizeLightBlocks;
    }

    public void setVoxelizeLightBlocks(boolean bl) {
        if (bl == this.voxelizeLightBlocks) {
            return;
        }
        this.reloadRequired = true;
        this.voxelizeLightBlocks = bl;
    }

    public boolean shouldSeparateEntityDraws() {
        return this.separateEntityDraws;
    }

    public void setSeparateEntityDraws(boolean bl) {
        this.separateEntityDraws = bl;
    }

    public boolean hasVillagerConversionId() {
        return this.hasVillagerConversionId;
    }
}

