/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.ithaka.digraph.util.fas;

import de.odysseus.ithaka.digraph.Digraph;
import de.odysseus.ithaka.digraph.Digraphs;
import de.odysseus.ithaka.digraph.EdgeWeights;
import de.odysseus.ithaka.digraph.MapDigraph;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSet;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSetPolicy;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSetProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class AbstractFeedbackArcSetProvider
implements FeedbackArcSetProvider {
    private final ExecutorService executor;

    protected AbstractFeedbackArcSetProvider() {
        this.executor = null;
    }

    protected AbstractFeedbackArcSetProvider(int n) {
        this.executor = n > 0 ? Executors.newFixedThreadPool(n) : null;
    }

    protected <V> Digraph<V> mfas(Digraph<V> digraph, EdgeWeights<? super V> edgeWeights) {
        return null;
    }

    protected abstract <V> Digraph<V> lfas(Digraph<V> var1, EdgeWeights<? super V> var2);

    private <V> FeedbackArcSet<V> fas(Digraph<V> digraph, EdgeWeights<? super V> var2_2, FeedbackArcSetPolicy feedbackArcSetPolicy) {
        boolean bl;
        EdgeWeights edgeWeights;
        class De_odysseus_ithaka_digraph_util_fas_AbstractFeedbackArcSetProvider$1
        implements EdgeWeights<V> {
            De_odysseus_ithaka_digraph_util_fas_AbstractFeedbackArcSetProvider$1() {
            }

            @Override
            public OptionalInt get(V v, V v2) {
                OptionalInt optionalInt = edgeWeights.get(v, v2);
                if (optionalInt.isPresent()) {
                    return OptionalInt.of(optionalInt.getAsInt() + bl2);
                }
                return OptionalInt.empty();
            }
        }
        De_odysseus_ithaka_digraph_util_fas_AbstractFeedbackArcSetProvider$1 var4_4 = var2_2;
        if (feedbackArcSetPolicy == FeedbackArcSetPolicy.MIN_SIZE) {
            edgeWeights = var2_2;
            final int bl2 = this.totalWeight(digraph, edgeWeights);
            var4_4 = new De_odysseus_ithaka_digraph_util_fas_AbstractFeedbackArcSetProvider$1();
        }
        edgeWeights = this.mfas(digraph, var4_4);
        boolean bl3 = true;
        if (edgeWeights == null) {
            edgeWeights = this.lfas(digraph, var4_4);
            bl = false;
        }
        return new FeedbackArcSet(edgeWeights, this.totalWeight((Digraph<V>)edgeWeights, var2_2), feedbackArcSetPolicy, bl);
    }

    protected <V> int totalWeight(Digraph<V> digraph, EdgeWeights<? super V> edgeWeights) {
        int n = 0;
        for (V v : digraph.vertices()) {
            for (V v2 : digraph.targets(v)) {
                n += edgeWeights.get(v, v2).getAsInt();
            }
        }
        return n;
    }

    private <V> List<FeedbackArcSet<V>> executeAll(List<FeedbackTask<V>> list) {
        ArrayList<FeedbackArcSet<V>> arrayList = new ArrayList<FeedbackArcSet<V>>();
        if (this.executor == null) {
            for (FeedbackTask<V> feedbackTask : list) {
                arrayList.add((FeedbackArcSet<V>)feedbackTask.call());
            }
        } else {
            try {
                for (Future<V> future : this.executor.invokeAll(list)) {
                    arrayList.add((FeedbackArcSet)future.get());
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return arrayList;
    }

    @Override
    public <V> FeedbackArcSet<V> getFeedbackArcSet(Digraph<V> digraph, EdgeWeights<? super V> edgeWeights, FeedbackArcSetPolicy feedbackArcSetPolicy) {
        if (Digraphs.isTriviallyAcyclic(digraph)) {
            return FeedbackArcSet.empty(feedbackArcSetPolicy);
        }
        List list = Digraphs.scc(digraph);
        if (list.size() == digraph.getVertexCount()) {
            return FeedbackArcSet.empty(feedbackArcSetPolicy);
        }
        if (list.size() == 1) {
            return this.fas(digraph, edgeWeights, feedbackArcSetPolicy);
        }
        ArrayList<FeedbackTask<V>> arrayList = new ArrayList<FeedbackTask<V>>();
        for (Set set : list) {
            if (set.size() <= 1) continue;
            arrayList.add(new FeedbackTask<V>(digraph, edgeWeights, feedbackArcSetPolicy, set));
        }
        List<FeedbackArcSet<V>> list2 = this.executeAll(arrayList);
        if (list2 == null) {
            return null;
        }
        int n = 0;
        boolean bl = true;
        MapDigraph mapDigraph = new MapDigraph();
        for (FeedbackArcSet feedbackArcSet : list2) {
            for (Object v : feedbackArcSet.vertices()) {
                for (Object v2 : feedbackArcSet.targets(v)) {
                    mapDigraph.put(v, v2, digraph.get(v, v2).getAsInt());
                }
            }
            bl &= feedbackArcSet.isExact();
            n += feedbackArcSet.getWeight();
        }
        return new FeedbackArcSet(mapDigraph, n, feedbackArcSetPolicy, bl);
    }

    class FeedbackTask<V>
    implements Callable<FeedbackArcSet<V>> {
        final Digraph<V> digraph;
        final EdgeWeights<? super V> weights;
        final FeedbackArcSetPolicy policy;
        final Set<V> scc;

        FeedbackTask(Digraph<V> digraph, EdgeWeights<? super V> edgeWeights, FeedbackArcSetPolicy feedbackArcSetPolicy, Set<V> set) {
            this.digraph = digraph;
            this.weights = edgeWeights;
            this.policy = feedbackArcSetPolicy;
            this.scc = set;
        }

        @Override
        public FeedbackArcSet<V> call() {
            return AbstractFeedbackArcSetProvider.this.fas(this.digraph.subgraph(this.scc), this.weights, this.policy);
        }
    }
}

