/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.ithaka.digraph.io.dot;

import de.odysseus.ithaka.digraph.Digraph;
import de.odysseus.ithaka.digraph.DigraphProvider;
import de.odysseus.ithaka.digraph.io.dot.DotAttribute;
import de.odysseus.ithaka.digraph.io.dot.DotProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DotExporter {
    private final String indent;
    private final String lineSpeparator;

    public DotExporter() {
        this("  ", System.getProperty("line.separator"));
    }

    public DotExporter(String string, String string2) {
        this.indent = string;
        this.lineSpeparator = string2;
    }

    private void indent(Writer writer, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write(this.indent);
        }
    }

    private void writeAttributes(Writer writer, Iterator<DotAttribute> iterator) throws IOException {
        if (iterator.hasNext()) {
            boolean bl = true;
            while (iterator.hasNext()) {
                if (bl) {
                    writer.write(91);
                    bl = false;
                } else {
                    writer.write(", ");
                }
                iterator.next().write(writer);
            }
            writer.write(93);
        }
    }

    private void writeDefaultAttributes(Writer writer, int n, String string, Iterable<DotAttribute> iterable) throws IOException {
        if (iterable != null) {
            this.indent(writer, n);
            Iterator<DotAttribute> iterator = iterable.iterator();
            if (iterator.hasNext()) {
                writer.write(string);
                this.writeAttributes(writer, iterator);
            }
            writer.write(";");
            writer.write(this.lineSpeparator);
        }
    }

    private <V> void writeNode(Writer writer, int n, V v, DotProvider<V, ?> dotProvider) throws IOException {
        this.indent(writer, n);
        writer.write(dotProvider.getNodeId(v));
        Iterable<DotAttribute> iterable = dotProvider.getNodeAttributes(v);
        if (iterable != null) {
            this.writeAttributes(writer, iterable.iterator());
        }
        writer.write(";");
        writer.write(this.lineSpeparator);
    }

    private <V> void writeEdge(Writer writer, int n, V v, V v2, int n2, DotProvider<V, ?> dotProvider, Cluster<V, ?> cluster, Cluster<V, ?> cluster2) throws IOException {
        this.indent(writer, n);
        writer.write(dotProvider.getNodeId(cluster == null ? v : cluster.sample));
        writer.write(" -> ");
        writer.write(dotProvider.getNodeId(cluster2 == null ? v2 : cluster2.sample));
        Iterable<DotAttribute> iterable = dotProvider.getEdgeAttributes(v, v2, n2);
        if (cluster == null && cluster2 == null) {
            if (iterable != null) {
                this.writeAttributes(writer, iterable.iterator());
            }
        } else {
            ArrayList<DotAttribute> arrayList = new ArrayList<DotAttribute>();
            if (cluster != null) {
                arrayList.add(cluster.tail);
            }
            if (cluster2 != null) {
                arrayList.add(cluster2.head);
            }
            if (iterable != null) {
                for (DotAttribute dotAttribute : iterable) {
                    arrayList.add(dotAttribute);
                }
            }
            this.writeAttributes(writer, arrayList.iterator());
        }
        writer.write(";");
        writer.write(this.lineSpeparator);
    }

    private <V, G extends Digraph<V>> Map<V, Cluster<V, G>> createClusters(G g, DotProvider<V, G> dotProvider, DigraphProvider<? super V, G> digraphProvider) {
        HashMap hashMap = new HashMap();
        if (digraphProvider != null) {
            for (V v : g.vertices()) {
                G g2 = digraphProvider.get(v);
                if (g2 == null || g2.getVertexCount() <= 0) continue;
                hashMap.put(v, new Cluster("cluster_" + dotProvider.getNodeId(v), g2));
            }
        }
        return hashMap;
    }

    public <V, G extends Digraph<V>> void export(DotProvider<V, G> dotProvider, G g, DigraphProvider<V, G> digraphProvider, Writer writer) throws IOException {
        writer.write("de.odysseus.ithaka.digraph G {");
        writer.write(this.lineSpeparator);
        Map<V, Cluster<V, G>> map = this.createClusters(g, dotProvider, digraphProvider);
        if (!map.isEmpty()) {
            this.indent(writer, 1);
            writer.write("compound=true;");
            writer.write(this.lineSpeparator);
        }
        this.writeDefaultAttributes(writer, 1, "graph", dotProvider.getDefaultGraphAttributes(g));
        this.writeDefaultAttributes(writer, 1, "node", dotProvider.getDefaultNodeAttributes(g));
        this.writeDefaultAttributes(writer, 1, "edge", dotProvider.getDefaultEdgeAttributes(g));
        this.writeNodesAndEdges(writer, 1, dotProvider, g, map, digraphProvider);
        writer.write("}");
        writer.write(this.lineSpeparator);
        writer.flush();
    }

    private <V, G extends Digraph<V>> void writeNodesAndEdges(Writer writer, int n, DotProvider<V, G> dotProvider, G g, Map<V, Cluster<V, G>> map, DigraphProvider<V, G> digraphProvider) throws IOException {
        for (V v : g.vertices()) {
            if (map.containsKey(v)) {
                this.writeCluster(writer, n, dotProvider, v, map.get(v), digraphProvider);
                continue;
            }
            this.writeNode(writer, n, v, dotProvider);
        }
        for (V v : g.vertices()) {
            for (V v2 : g.targets(v)) {
                this.writeEdge(writer, n, v, v2, g.get(v, v2).getAsInt(), dotProvider, map.get(v), map.get(v2));
            }
        }
    }

    private <V, G extends Digraph<V>> void writeCluster(Writer writer, int n, DotProvider<V, G> dotProvider, V v, Cluster<V, G> cluster, DigraphProvider<V, G> digraphProvider) throws IOException {
        this.indent(writer, n);
        writer.write("subgraph ");
        writer.write(cluster.id);
        writer.write(" {");
        writer.write(this.lineSpeparator);
        this.writeDefaultAttributes(writer, n + 1, "graph", dotProvider.getSubgraphAttributes(cluster.subgraph, v));
        Map map = this.createClusters(cluster.subgraph, dotProvider, (DigraphProvider<? super V, G>)digraphProvider);
        this.writeNodesAndEdges(writer, n + 1, dotProvider, cluster.subgraph, map, digraphProvider);
        this.indent(writer, n);
        writer.write("}");
        writer.write(this.lineSpeparator);
    }

    private static class Cluster<V, G extends Digraph<V>> {
        String id;
        G subgraph;
        V sample;
        DotAttribute tail;
        DotAttribute head;

        public Cluster(String string, G g) {
            this.id = string;
            this.subgraph = g;
            this.sample = g.vertices().iterator().next();
            this.head = new DotAttribute("lhead", string);
            this.tail = new DotAttribute("ltail", string);
        }
    }
}

